<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model wdigital\cms\gallery\models\GalleryType */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="gallery-type-form">

    <?php $form = ActiveForm::begin(); ?>

    <?php if(Yii::$app->getModule('gallery')->translate
    && ArrayHelper::keyExists('wdigital\cms\i18n\components\translatableModel\TranslatableTrait', class_uses($model))): ?>
    <ul class="nav nav-tabs col-sm-12 lang-tabs-style">
        <?php foreach (Yii::$app->params['languages'] as $language): ?>
            <li <?php if (Yii::$app->language === $language['code']): ?> class="active" <?php endif ?> ><a href="#gallery-new-<?= $language['code'] ?>" data-toggle="tab"><?= Html::encode($language['name']); ?></a></li>
        <?php endforeach ?>
    </ul>
    <div class="tab-content">
        <?php foreach (Yii::$app->params['languages'] as $language): ?>
            <div class="tab-pane fade in <?php if (Yii::$app->language === $language['code']): ?> active <?php endif; ?>" id="gallery-new-<?= $language['code'] ?>">
                <?= $form->field($model, "[translations][{$language['code']}][title]")->textInput(['maxlength' => true, 'class' => 'form-control', 'value' => $model->getAttribute('title', $language['code'])])->label(Yii::t('gallery', 'Title', [], $language['code'])); ?>
            </div>
        <?php endforeach; ?>
    <?php else: ?>

    <?= $form->field($model, 'title')->textInput(['maxlength' => true, 'class' => 'form-control']) ?>

    <?php endif; ?>
    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? Yii::t('gallery', 'Create') : Yii::t('gallery', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-primary' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
