<?php

namespace wdigital\cms\gallery\models;

use DateTime;
use wdigital\cms\gallery\components\FileControl;
use Yii;
use yii\db\ActiveQuery;
use yii\db\ActiveRecord;
use yii\helpers\StringHelper;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;

/**
 * This is the model class for table "{{%gallery}}".
 *
 * @property integer $id
 * @property string $title
 * @property string $description
 * @property string $date
 * @property string $author
 * @property integer $published
 *
 * @property GalleryType[] $galleryTypes
 * @property Photo[] $photos
 */
class Gallery extends ActiveRecord
{

    /**
     * @var
     */
    private $_galleryTypes;

//    /**
//     * @return GalleryType[]
//     */
//    public function getRelatedGalleryTypes()
//    {
//        return $this->galleryTypes;
//    }

//    /**
//     * @param $value
//     */
//    public function setRelatedGalleryTypes($value)
//    {
//        if ($this->getRelation('galleryTypes', false)) {
//            $this->unlinkAll('galleryTypes', true);
//        }
//        if ($value) {
//            $relatedClassName = Yii::$app->getModule('gallery')->galleryTypeClass;
//            $relatedClassInstances = $relatedClassName::find()->where(['in', 'id', $value])->all();
//            foreach ($relatedClassInstances as $relatedClassInstance) {
//                $this->link('galleryTypes', $relatedClassInstance);
//            }
//        }
//    }

    /**
     * Publically accessable subdirectory for file storage.
     */
    const IMG_DIR = 'gallery/photos';
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%gallery}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            ['title', 'required'],
            [['description'], 'string'],
            [['date', 'galleryTypes'], 'safe'],
            [['date'], 'date', 'format' => 'php:d.m.Y'],
            ['date', 'filter', 'filter' => function ($value) {
                    if (!empty($value)) {
                        $date = DateTime::createFromFormat('d.m.Y', $value);
                        if ($date) {
                            return $date->format('Y-m-d');
                        } else {
                            return date('Y-m-d');
                        }
                    } else {
                        return date('Y-m-d');
                    }
            }],
            [['published'], 'integer'],
            [['title', 'author'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('gallery', 'ID'),
            'title' => Yii::t('gallery', 'Title'),
            'description' => Yii::t('gallery', 'Description'),
            'date' => Yii::t('gallery', 'Date'),
            'author' => Yii::t('gallery', 'Author'),
            'published' => Yii::t('gallery', 'Published'),
            'galleryTypes' => Yii::t('gallery', 'Related gallery types'),
        ];
    }

    /**
     * @return ActiveQuery
     */
    public function getGalleryTypes()
    {
        return $this->hasMany(GalleryType::className(), ['id' => 'gallery_type_id'])->viaTable('{{%gallery_to_gallery_type}}', ['gallery_id' => 'id']);
    }

    /**
     * @return ActiveQuery
     */
    public function setGalleryTypes($galleryTypes)
    {
        if(empty($galleryTypes)){
            $galleryTypes = [];
        }
        $this->_galleryTypes = $galleryTypes;

        $saveGalleryTypes = function($event){
            $this->unlinkAll('galleryTypes', true);
            $relatedClass = Yii::$app->getModule('gallery')->galleryTypeClass;
            $relatedClass = new $relatedClass;
            $query = $relatedClass::find()->where(['in', 'id', $this->_galleryTypes]);
            if(Yii::$app->getModule('gallery')->translate
                && ArrayHelper::keyExists('wdigital\cms\i18n\components\translatableModel\TranslatableTrait', class_uses($relatedClass))) {
                $query->andWhere([$relatedClass::tableName().'.language' => Yii::$app->language]);
            }
            $relatedClassInstances = $query->all();
            foreach ($relatedClassInstances as $relatedClassInstance){
                $this->link('galleryTypes', $relatedClassInstance);
            }
        };

        $this->on(self::EVENT_AFTER_INSERT, $saveGalleryTypes);
        $this->on(self::EVENT_AFTER_UPDATE, $saveGalleryTypes);
    }


    /**
     * @return ActiveQuery
     */
    public function getPhotos()
    {
        return $this->hasMany(Photo::className(), ['gallery_id' => 'id']);
    }

    /**
     * Creates related gallery photo instances and saves its files on filesystem.
     * Sent files need to have a name of images as input field.
     * @var PhotoUpload $photoUpload
     * @return bool
     */
    public function saveRelatedPhotos(PhotoUpload $photoUpload)
    {
        $photoUpload->images = UploadedFile::getInstances($photoUpload, 'images');
        if ($photoUpload->validate()) {
            foreach ($photoUpload->images as $post) {
                $photo = new Photo();
                if ($photo->create($post, $this)) {
                    FileControl::uploadFile($post, self::IMG_DIR, $photo->filename);
                }
            }
            return true;
        } else {
            return false;
        }
    }
}
