<?php

namespace wdigital\cms\gallery\migrations;
use yii\db\Migration;

/**
 * Handles the creation of table `photo`.
 */
class m171214_112929_create_photo_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $isLanguage = $this->db->schema->getTableSchema('language', true);
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('{{%photo}}', [
            'id' => $this->primaryKey()->unsigned(),
            'gallery_id' => $this->integer()->notNull()->unsigned(),
            'filename' => $this->string(),
            'description' => $this->string(),
            'order_by' => $this->integer(11)->unsigned(),
        ], $tableOptions);
        $this->createIndex('idx_gallery_id', '{{%photo}}', 'gallery_id');
		$this->addForeignKey('fk_photo_to_gallery_id', '{{%photo}}', 'gallery_id', '{{%gallery}}', 'id', 'CASCADE', 'RESTRICT');

		if ($isLanguage) {
            $this->createTable('{{%photo_translation}}', [
                'photo_id' => $this->integer()->unsigned()->notNull(),
                'language_id' => $this->integer()->unsigned()->notNull(),
                'description' => $this->string(),
            ], $tableOptions);

            $this->addPrimaryKey('pk_photo_translation', '{{%photo_translation}}', ['photo_id', 'language_id']);
            $this->createIndex('idx_photo_translation_to_photo', '{{%photo_translation}}', 'photo_id');
            $this->addForeignKey('fk_photo_translation_to_photo', '{{%photo_translation}}', 'photo_id', '{{%photo}}', 'id', 'CASCADE', 'RESTRICT');
            $this->createIndex('idx_photo_translation_to_language', '{{%photo_translation}}', 'language_id');
            $this->addForeignKey('fk_photo_translation_to_language', '{{%photo_translation}}', 'language_id', '{{%language}}', 'id', 'CASCADE', 'RESTRICT');

        } else {
            echo "No language table detected, photo translations omitted";
        }
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $isLanguage = $this->db->schema->getTableSchema('language', true);
        if ($isLanguage) {
            $this->dropForeignKey('fk_photo_translation_to_language', '{{%photo_translation}}');
            $this->dropForeignKey('fk_photo_translation_to_photo', '{{%photo_translation}}');
            $this->dropTable('{{%photo_translation}}');
        }
        $this->dropForeignKey('fk_photo_to_gallery_id', '{{%photo}}');
        $this->dropTable('{{%photo}}');
    }
}
