<?php

namespace wdigital\cms\gallery\controllers;

use wdigital\cms\gallery\models\Gallery;
use wdigital\cms\gallery\models\GallerySearch;
use wdigital\cms\gallery\models\GalleryType;
use wdigital\cms\gallery\models\Photo;
use wdigital\cms\gallery\models\PhotoUpload;
use Yii;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;

/**
 * DefaultController implements the CRUD actions for Gallery model.
 */
class DefaultController extends Controller
{

    /**
     * Lists all Gallery models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new GallerySearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        $galleryTypeClass = new $galleryTypeClass;
        if(Yii::$app->getModule('gallery')->translate
            && ArrayHelper::keyExists('wdigital\cms\i18n\components\translatableModel\TranslatableTrait', class_uses($galleryTypeClass))) {
            $query = $galleryTypeClass::find()
                ->where([$galleryTypeClass::tableName().'.language' => Yii::$app->language]);
        } else {
            $query = $galleryTypeClass::find();
        }
        $typeProvider = new ActiveDataProvider([
           'query' => $query,
        ]);
        return $this->render('@vendor/wdigital/cms-gallery/src/views/default/index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'typeProvider' => $typeProvider,
        ]);
    }

    /**
     * Creates a new Gallery model.
     * If creation is successful, the browser will be redirected to the 'index' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $galleryClass = Yii::$app->getModule('gallery')->galleryClass;
        $model = new $galleryClass;
        $photoUpload = new PhotoUpload();
        if ($model->load(Yii::$app->request->post()) && $model->save()
                && (empty(UploadedFile::getInstances($photoUpload, 'images'))
                || $model->saveRelatedPhotos($photoUpload))) {
            return $this->redirect(['update', 'id' => $model->id]);
        }
        $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        $classInstance = new $galleryTypeClass;
        if(Yii::$app->getModule('gallery')->translate) {
            $types = $classInstance::find()->where([$classInstance::tableName().'.language' => Yii::$app->language])->select('title')->indexBy('id')->column();

        } else {
            $types = $classInstance::find()->select('title')->indexBy('id')->column();

        }
        return $this->render('@vendor/wdigital/cms-gallery/src/views/default/create', [
                    'model' => $model,
                    'types' => $types,
                    'photoUpload' => $photoUpload,
        ]);
    }

    /**
     * Updates an existing Gallery model.
     * If update is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $photoUpload = new PhotoUpload();
        if ($model->load(Yii::$app->request->post()) && $model->save() && (empty(UploadedFile::getInstances($photoUpload, 'images')) || $model->saveRelatedPhotos($photoUpload))) {
            return $this->redirect(['update', 'id' => $model->id]);
        }
        $photoClass = Yii::$app->getModule('gallery')->photoClass;
        $photoClass = new $photoClass;
        if(Yii::$app->getModule('gallery')->translate
            && ArrayHelper::keyExists('wdigital\cms\i18n\components\translatableModel\TranslatableTrait', class_uses($photoClass))) {
            $query = $photoClass::find()
                ->where([$photoClass::tableName().'.language' => Yii::$app->language]);
        } else {
            $query = $photoClass::find();
        }
        $photos = $query->andwhere(['gallery_id' => $model->id])->orderBy('order_by')->all();
        $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        if(Yii::$app->getModule('gallery')->translate) {
            $types = $galleryTypeClass::find()->where([$galleryTypeClass::tableName().'.language' => Yii::$app->language])->select('title')->indexBy('id')->column();

        } else {
            $types = $galleryTypeClass::find()->select('title')->indexBy('id')->column();

        }
        return $this->render('@vendor/wdigital/cms-gallery/src/views/default/update', [
                    'model' => $model,
                    'types' => $types,
                    'photos' => $photos,
                    'photoUpload' => $photoUpload,
        ]);
    }

    /**
     * Deletes an existing Gallery model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $model = $this->findModel($id);
        if(!empty($model->photos)){
            foreach($model->photos as $photo) {
                $photo->destroy();
            }
        }
        $model->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the Gallery model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Gallery the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        $galleryClass = Yii::$app->getModule('gallery')->galleryClass;
        if (($model = $galleryClass::find()->where([$galleryClass::tableName().'.id' => $id])->limit(1)->one()) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException();
        }
    }
}
