<?php

use wdigital\cms\inspinia\widgets\FileInput;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
/* @var $model Gallery */
/* @var $form ActiveForm */
?>

<div class="gallery-form">

    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>

    <?php if (Yii::$app->getModule('gallery')->translate
    && ArrayHelper::keyExists('wdigital\cms\i18n\components\translatableModel\TranslatableTrait',
        class_uses($model))): ?>
    <ul class="nav nav-tabs col-sm-12 lang-tabs-style">
        <?php foreach (Yii::$app->params['languages'] as $language): ?>
            <li <?php if (Yii::$app->language === $language['code']): ?> class="active" <?php endif ?> ><a
                        href="#gallery-new-<?= $language['code'] ?>"
                        data-toggle="tab"><?= Html::encode($language['name']); ?></a></li>
        <?php endforeach ?>
    </ul>
    <div class="tab-content">
        <?php foreach (Yii::$app->params['languages'] as $language): ?>
            <div class="tab-pane fade in <?php if (Yii::$app->language === $language['code']): ?> active <?php endif; ?>"
                 id="gallery-new-<?= $language['code'] ?>">
                <?= $form->field($model, "translations[{$language['code']}][title]")->textInput([
                    'maxlength' => true,
                    'class' => 'form-control',
                    'value' => $model->getAttribute('title', $language['code'])
                ])->label(Yii::t('gallery', 'Title', [], $language['code'])); ?>

                <?= $form->field($model, "translations[{$language['code']}][description]")->textarea([
                    'rows' => 6,
                    'class' => 'ckeditor',
                    'value' => $model->getAttribute('description', $language['code'])
                ])->label(Yii::t('gallery', 'Description', [], $language['code'])); ?>
            </div>
        <?php endforeach; ?>

        <?php else: ?>

            <?= $form->field($model, 'title')->textInput([
                'maxlength' => true,
                'data-slug-field' => 'new-gallery',
                'class' => 'form-control js-slug-field',
            ]) ?>

            <?= $form->field($model, 'description')->textarea(['rows' => 6, 'class' => 'ckeditor']) ?>

        <?php endif; ?>

        <?= $form->field($model, 'date')->textInput([
            'class' => 'form-control datepicker',
            'value' => Yii::$app->formatter->asDate($model->date, 'php:d.m.Y'),
        ]) ?>

        <?= $form->field($model, 'author')->textInput(['maxlength' => true]) ?>

        <?= $form->field($model, 'galleryTypes')->dropDownList($types,
            ['class' => 'form-control js-select2', 'multiple' => 'multiple']) ?>

        <?= $form->field($model, 'published')->checkbox(['class' => 'js-icheck']) ?>

        <?= FileInput::widget([
            'model' => $photoUpload,
            'multiple' => 'multiple',
            'name' => 'PhotoUpload[images][]',
        ]); ?>

        <div class="form-group">
            <?= Html::submitButton($model->isNewRecord ? Yii::t('gallery', 'Create') : Yii::t('gallery', 'Update'),
                ['class' => $model->isNewRecord ? 'btn btn-primary' : 'btn btn-primary']) ?>
        </div>

        <?php ActiveForm::end(); ?>

    </div>
</div>