<?php

namespace wdigital\cms\gallery\controllers;

use wdigital\cms\gallery\models\Photo;
use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\Response;
use yii\web\UnprocessableEntityHttpException;

/**
 * PhotoController implements the CRUD actions for Photo model.
 */
class PhotoController extends Controller
{

    /**
     * Updates an existing Photo model.
     * If update is successful, the browser will be redirected to either 'gallery page' or 'gallery index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $gallery = $model->gallery;
        if ($model->load(Yii::$app->request->post()) && $model->save() && !empty($gallery)) {
            return $this->redirect(['default/update', 'id' => $gallery->id]);
        } elseif (!empty($gallery)) {
            return $this->redirect(['default/update', 'id' => $gallery->id]);
        } else {
            return $this->redirect(['default/index']);
        }
    }

    /**
     * Updates an existing Photo models description.
     * If update is successful, a successful JSON message will be sent.
     * @param integer $id
     * @return mixed
     * @throws UnprocessableEntityHttpException if model could not be updated
     * @throws NotFoundHttpException if the request is not of Ajax nature
     */
    public function actionUpdatePhotoDescription($id)
    {
        if (Yii::$app->request->isAjax) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            throw new NotFoundHttpException('TLOR');
            $model = $this->findModel($id);
            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                Yii::$app->response->data = ['data' => ['message' => Yii::t('gallery', 'Gallery photo modified')]];
                return;
            } else {
                throw new UnprocessableEntityHttpException(Yii::t('gallery', 'Gallery photo could not be modified'));
            }
        } else {
            throw new NotFoundHttpException();
        }
    }

    /**
     * Updates multiple existing Photo models order.
     * If update is successful, a successful JSON message will be sent.
     * @return mixed
     * @throws NotFoundHttpException if the request is not of Ajax nature
     */
    public function actionUpdatePhotoOrder()
    {
        if (Yii::$app->request->isAjax) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            $post = Yii::$app->request->post();
            $ids = implode(',', array_keys($post));
            $photo = new Photo();
            $tablename = $photo->tableName();
            $cases = '';
            foreach ($post as $id => $orderBy){
                $cases.= "WHEN `id`=$id THEN $orderBy ";
            }
            Yii::$app->db->createCommand("UPDATE $tablename SET `order_by` = (CASE $cases END) WHERE `id` IN ($ids)")->execute();
            Yii::$app->response->data = ['data' => ['message' => Yii::t('gallery', 'Gallery photos modified')]];
            return;
        } else {
            throw new NotFoundHttpException();
        }
    }

    /**
     * Deletes an existing Photo model.
     * If deletion is successful, the browser will be redirected to either 'gallery page' or 'gallery index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $model = $this->findModel($id);
        $gallery = $model->gallery;
        $model->destroy();
        if(!empty($gallery)){
            return $this->redirect(['default/update', 'id' => $gallery->id]);
        } else {
            return $this->redirect(['default/index']);
        }

    }

    /**
     * Finds the Photo model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Photo the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        $photoClass = Yii::$app->getModule('gallery')->photoClass;
        if (($model = $photoClass::find()->where([$photoClass::tableName().'.id' => $id])->limit(1)->one()) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException();
        }
    }
}
