<?php

namespace wdigital\cms\gallery\controllers;

use wdigital\cms\gallery\models\GalleryType;
use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;

/**
 * GalleryTypeController implements the CRUD actions for GalleryType model.
 */
class GalleryTypeController extends Controller
{

    /**
     * Creates a new GalleryType model.
     * If creation is successful, the browser will be redirected to the 'default/index' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        $model = new $galleryTypeClass;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['default/index']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing GalleryType model.
     * If update is successful, the browser will be redirected to the 'default/index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $galleryTypeClass = $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        $model = $galleryTypeClass::find()
            ->where([$galleryTypeClass::tableName().'.id' => $id])
            ->limit(1)->one();
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['default/index']);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing GalleryType model.
     * If deletion is successful, the browser will be redirected to the 'default/index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['default/index']);
    }

    /**
     * Finds the GalleryType model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return GalleryType the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = GalleryType::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException();
        }
    }
}
