<?php

use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model wdigital\cms\gallery\models\Gallery */

$this->title = Yii::t('gallery', 'Update {modelClass}: ', [
            'modelClass' => 'Gallery',
        ]) . $model->title;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gallery', 'Galleries'), 'url' => ['index']];
$this->params['breadcrumbs'][] = Yii::t('gallery', 'Update');
?>
<div class="gallery-update">
    <div class="row">
        <div class="col-lg-6">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Html::encode($this->title) ?></h5>
                    <small class="pull-right">
                        <?= Yii::t('gallery', 'By submitting this form, you can update gallery') ?>
                    </small>
                </div>
                <div class="ibox-content">
                    <?=
                    $this->render('_form', [
                        'model' => $model,
                        'types' => $types,
                        'photoUpload' => $photoUpload,
                    ]);
                    ?>
                </div>
            </div>
        </div>
        <?php if ($photos): ?>
        <div class="col-lg-6">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Html::encode(Yii::t('gallery', 'Gallery photos')) ?></h5>
                    <small class="pull-right">
                        <?= Yii::t('gallery', 'By using this form you can manipulate with gallery photos') ?>
                    </small>
                </div>
                <div class="ibox-content">
                    <?=
                    $this->render('_photos', [
                        'photos' => $photos,
                    ]);
                    ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
