<?php

use yii\helpers\StringHelper;
use yii\helpers\Url;
?>
<div class="photo-form">
    <table class="table table-striped js-sort"
           data-url=<?= Url::to(['photo/update-photo-order']); ?>
           data-toastr-success="<?= Yii::t('gallery', 'Photo changes successful'); ?>"
           data-toastr-error="<?= Yii::t('gallery', 'Photo changes unsuccessful'); ?>"
           >
        <?php foreach ($photos as $photo): ?>
            <tr data-id="<?= $photo->id ?>">
                <td><img style="max-height: 100px; max-width: 100px;" src="<?= $photo->getImageUrl() ?>"></td>
                <td>
                    <input type="text" name="description" placeholder="<?= Yii::t('gallery', 'Picture description') ?>" class="form-control" value="<?= $photo->description ?>">
                </td>
                <td align="right" class="w120px">
                    <button
                        class="btn btn-xs btn-primary js-photo-description"
                        data-url="<?= Url::to(['photo/update-photo-description', 'id' => $photo->id]); ?>"
                        data-class ="<?= StringHelper::basename(get_class($photo)); ?>"
                        data-toastr-success="<?= Yii::t('gallery', 'Photo changes successful'); ?>"
                        data-toastr-error="<?= Yii::t('gallery', 'Photo changes unsuccessful'); ?>"
                        >
                            <i class="fa fa-fw fa-save"></i>
                    </button>
                    <button href="#"
                            class="btn btn-warning btn-xs sortable-handle">
                                <i class="fa fa-arrows fa-fw"></i>
                    </button>
                    <a href="<?= Url::to(['photo/delete', 'id' => $photo->id])?>"
                        class="btn btn-xs btn-danger sweetalert-warning"
                        data-title= "<?= Yii::t('gallery', 'Delete picture') ?>"
                        data-text="<?= Yii::t('gallery', 'Are you sure, you want to delete this picture?') ?>"
                        >
                        <i class="fa fa-trash fa-fw"></i>
                    </a>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>
