<?php

use wdigital\cms\gallery\models\Gallery;
use wdigital\cms\inspinia\widgets\FileInput;
use yii\helpers\Html;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
/* @var $model Gallery */
/* @var $form ActiveForm */
?>

<div class="gallery-form">

    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>

    <?= $form->field($model, 'title')->textInput(['maxlength' => true, 'data-slug-field' => 'new-gallery', 'class' => 'form-control js-slug-field']) ?>

    <?= $form->field($model, 'description')->textarea(['rows' => 6, 'class' => 'ckeditor']) ?>

    <?= $form->field($model, 'date')->textInput(['class' => 'form-control datepicker', 'value' => Yii::$app->formatter->asDate($model->date, 'php:d.m.Y')]) ?>

    <?= $form->field($model, 'author')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'galleryTypes')->dropDownList($types, ['class' => 'form-control js-select2', 'multiple' => 'multiple']) ?>

    <?= $form->field($model, 'published')->checkbox(['class' => 'js-icheck']) ?>

    <?= FileInput::widget(['model' => $photoUpload, 'multiple' => 'multiple', 'name' => 'PhotoUpload[images][]']); ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? Yii::t('gallery', 'Create') : Yii::t('gallery', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-primary' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>
    
</div>
