<?php

namespace wdigital\cms\gallery\migrations;
use yii\db\Migration;

/**
 * Handles the creation of table `photo`.
 */
class m171214_112929_create_photo_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('{{%photo}}', [
            'id' => $this->primaryKey()->unsigned(),
            'gallery_id' => $this->integer()->notNull()->unsigned(),
            'filename' => $this->string(),
            'description' => $this->string(),
            'order_by' => $this->integer(11)->unsigned(),
        ], $tableOptions);
        $this->createIndex('idx_gallery_id', '{{%photo}}', 'gallery_id');
		$this->addForeignKey('fk_photo_to_gallery_id', '{{%photo}}', 'gallery_id', '{{%gallery}}', 'id', 'CASCADE', 'RESTRICT');
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropForeignKey('fk_photo_to_gallery_id', '{{%photo}}');
        $this->dropTable('{{%photo}}');
    }
}
