<?php

namespace wdigital\cms\gallery\controllers;

use wdigital\cms\gallery\models\Gallery;
use wdigital\cms\gallery\models\GallerySearch;
use wdigital\cms\gallery\models\GalleryType;
use wdigital\cms\gallery\models\Photo;
use wdigital\cms\gallery\models\PhotoUpload;
use Yii;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;

/**
 * DefaultController implements the CRUD actions for Gallery model.
 */
class DefaultController extends Controller
{

    /**
     * Lists all Gallery models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new GallerySearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $typeProvider = new ActiveDataProvider([
           'query' => GalleryType::find(),
        ]);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'typeProvider' => $typeProvider,
        ]);
    }

    /**
     * Creates a new Gallery model.
     * If creation is successful, the browser will be redirected to the 'index' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Gallery();
        $photoUpload = new PhotoUpload();
        if ($model->load(Yii::$app->request->post()) && $model->save()
                && (empty(UploadedFile::getInstances($photoUpload, 'images'))
                || $model->saveRelatedPhotos($photoUpload))) {
            $model->linkRelated();
            return $this->redirect(['update', 'id' => $model->id]);
        }
        $types = GalleryType::find()->select('title')->indexBy('id')->column();
        return $this->render('create', [
                    'model' => $model,
                    'types' => $types,
                    'photoUpload' => $photoUpload,
        ]);
    }

    /**
     * Updates an existing Gallery model.
     * If update is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $photoUpload = new PhotoUpload();
        if ($model->load(Yii::$app->request->post()) && $model->save() && (empty(UploadedFile::getInstances($photoUpload, 'images')) || $model->saveRelatedPhotos($photoUpload))) {
            $model->linkRelated();
            return $this->redirect(['update', 'id' => $model->id]);
        }
        $photos = Photo::find()->where(['gallery_id' => $model->id])->orderBy('order_by')->all();
        $types = GalleryType::find()->select('title')->indexBy('id')->column();
        return $this->render('update', [
                    'model' => $model,
                    'types' => $types,
                    'photos' => $photos,
                    'photoUpload' => $photoUpload,
        ]);
    }

    /**
     * Deletes an existing Gallery model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $model = $this->findModel($id);
        if(!empty($model->photos)){
            foreach($model->photos as $photo) {
                $photo->destroy();
            }
        }
        $model->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the Gallery model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Gallery the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Gallery::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException();
        }
    }
}
