White Digital Yii2 Gallery Module Package
===========================================================

## Installation

### 1. Download

The preferred way to install this module is via [composer].

First, add the White Digital Composer repository to your `composer.json`:

    "repositories": [{
        "type": "composer",
        "url": "https://composer.wdigital.lv"
    }]

After that, either run

    $ composer require wdigital/cms-gallery:^0.2.0

or add

    "wdigital/cms-gallery": "^0.2.0"

to the `require` section of your `composer.json` file.

### 2. Configure

Configure gallery module for your application

> IMPORTANT! Ensure that your application does not have a `gallery` component configured beforehand.
Add module and name it in application configuration

        'modules' => [
            'gallery' => [
                'class' => wdigital\cms\gallery\Module::class,
            ]
        ],

Configure response formatter component for your application to use standartizied Jsend responses to AJAX calls

        'response' => [
            'formatters' => [
                \yii\web\Response::FORMAT_JSON => [
                    'class' => wdigital\cms\gallery\components\JsendResponseFormatter::class,
                ],
            ],
        ],

Add a common storage location and name it '@storage' in common/bootstrap.php file for your application to save files on filesystem

        Yii::setAlias('@storage', dirname(dirname(__DIR__)) . '/storage');

### 3. Migrate

Run migrations to create gallery and photo DB structure

        php yii migrate/up --migrationNamespaces=wdigital\\cms\\gallery\\migrations
