<?php

namespace wdigital\cms\dynamicContentModel\models;

use wdigital\cms\i18new\components\ActiveRecordHelper;
use wdigital\cms\i18new\components\TranslationHelper;
use wdigital\cms\i18new\models\Language;
use yii\base\Model;
use yii\db\ActiveQuery;
use yii\db\ActiveRecord;
use yii\helpers\ArrayHelper;
use yii2tech\ar\variation\VariationBehavior;

/**
 * This is the model class for table "setting".
 *
 * @property int $id [int(10) unsigned]
 * @property string $key [varchar(255)]
 *
 * @property array $variationModels
 * @property ActiveQuery $defaultTranslation
 * @property SettingTranslation[] $settingTranslations
 * @property string $value
 *
 * @method getVariationModels()
 * @method setVariationModels(array $translationModels)
 * @method hasDefaultVariationRelation()
 * @method SettingTranslation getVariationModel(int $langId)
 */
class Setting extends ActiveRecord
{
    public static function primaryField(): string
    {
        return 'key';
    }

    public function behaviors(): array
    {
        return [
            'translations' => [
                'class' => VariationBehavior::class,
                'variationsRelation' => 'settingTranslations',
                'defaultVariationRelation' => 'defaultTranslation',
                'variationOptionReferenceAttribute' => 'language_id',
                'variationAttributeDefaultValueMap' => [
                    'value' => null,
                ],
                'optionModelClass' => Language::class,
                'defaultVariationOptionReference' => [TranslationHelper::class, 'getCurrentLanguage'],
                'variationSaveFilter' => [ActiveRecordHelper::class, 'filterVariationSave'],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName(): string
    {
        return 'setting';
    }

    /**
     * @inheritdoc
     */
    public function rules(): array
    {
        return [
            [['key'], 'required'],
            [['key'], 'string', 'max' => 255],
            ['value', 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels(): array
    {
        return [
            'id' => 'ID',
            'key' => 'Key',
        ];
    }

    public function getSettingTranslations(): ActiveQuery
    {
        return $this->hasMany(SettingTranslation::class, ['setting_id' => 'id']);
    }

    public function getDefaultTranslation(): ActiveQuery
    {
        return $this->hasDefaultVariationRelation();
    }

    /**
     * @param array $data
     * @param null $formName
     * @return bool
     */
    public function load($data, $formName = null): bool
    {
        $translationModels = ArrayHelper::map(
            $this->getVariationModels(),
            'language_id',
            static function ($translatedModel) {
                return $translatedModel;
            }
        );
        return Model::loadMultiple($translationModels, $data) && $this->setVariationModels($translationModels);
    }
}
