<?php

namespace wdigital\cms\dynamicContentModel\models;

use Yii;
use yii\base\InvalidConfigException;
use yii\base\Model;
use yii\helpers\Json;
use yii\helpers\StringHelper;

abstract class AbstractSettingModel extends Model
{
    /**
     * @return static
     * @throws InvalidConfigException
     */
    public static function instantiate(): static
    {
        $classKey = strtolower(StringHelper::basename(static::class));
        /* @var $settingModel Setting */
        $settingModel = Yii::createObject(Setting::class);
        $setting = $settingModel::find()
            ->innerJoinWith('defaultTranslation')
            ->where(['key' => $classKey])
            ->limit(1)
            ->one();
        if (!$setting) {
            $setting = new $settingModel(['key' => $classKey]);
        }
        $model = (new static());
        $model->setAttributes(Json::decode($setting->value, true));
        return $model;
    }

    /**
     * @throws InvalidConfigException
     */
    public function insertOrUpdate(): bool
    {
        $classKey = strtolower(StringHelper::basename(static::class));
        /* @var $settingModel Setting */
        $settingModel = Yii::createObject(Setting::class);
        $setting = $settingModel::find()
            ->where(['key' => $classKey])
            ->limit(1)
            ->one();
        if (!$setting) {
            $setting = new $settingModel(['key' => $classKey]);
        }
        $setting->value = Json::encode($this->getAttributes());
        return $setting->save();
    }

    /**
     * @throws InvalidConfigException
     */
    public static function getValues(): array
    {
        $model = static::instantiate();
        return $model->getAttributes();
    }
}
