<?php

namespace wdigital\cms\dynamicContentModel\migrations;

use yii\base\Exception;
use yii\db\Migration;

/**
 * Class m210608_101953_recreate_value_column_content_table
 */
class m210608_101953_add_timestamp_change_value_column_content_table extends Migration
{
    /**
     * {@inheritdoc}
     * @throws Exception
     */
    public function safeUp(): void
    {
        $this->dropColumn('content_translation', 'value');
        $this->addColumn('content_translation', 'value', $this->json());
        $this->addColumn('content', 'created_at', $this->dateTime());
        $this->addColumn('content', 'updated_at', $this->dateTime());
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown(): void
    {
        $this->dropColumn('content_translation', 'value');
        $this->addColumn('content_translation', 'value', $this->text());
        $this->dropColumn('content', 'created_at');
        $this->dropColumn('content', 'updated_at');
    }
}
