<?php

namespace wdigital\cms\dynamicContentModel\migrations;

use yii\db\Migration;

/**
 * Handles the creation of table `{{%content}}`.
 */
class m210526_162445_create_content_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp(): bool
    {
        $tableOptions = '';
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8mb4_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%content}}', [
            'id' => $this->primaryKey()->unsigned(),
            'key' => $this->string()->notNull(),
            'position' => $this->integer(),
            'active' => $this->integer(),
        ], $tableOptions);

        $this->createTable('content_translation', [
            'id' => $this->primaryKey()->unsigned(),
            'content_id' => $this->integer()->unsigned(),
            'language_id' => $this->integer()->unsigned(),
            'value' => $this->text(),
        ], $tableOptions);

        $this->createIndex(
            'idx_content_key',
            'content',
            'key'
        );

        $this->createIndex(
            'idx_translation_content',
            'content_translation',
            'content_id'
        );
        $this->createIndex(
            'idx_content_translation_language',
            'content_translation',
            'language_id'
        );
        $this->addForeignKey(
            'fk_translation_content_content',
            'content_translation',
            'content_id',
            'content',
            'id',
            'CASCADE'
        );
        $this->addForeignKey(
            'fk_content_translation_language',
            'content_translation',
            'language_id',
            'language',
            'id',
            'CASCADE'
        );

        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown(): bool
    {
        $this->dropForeignKey(
            'fk_translation_content_content', 'content_translation'
        );
        $this->dropForeignKey(
            'fk_content_translation_language', 'content_translation'
        );

        $this->dropTable('{{%content}}');
        $this->dropTable('{{%content_translation}}');

        return true;
    }
}
