<?php

namespace wdigital\cms\dynamicContentModel;

use wdigital\cms\dynamicContentModel\models\Content;
use wdigital\cms\dynamicContentModel\models\Setting;
use Yii;
use yii\base\Module as BaseModule;
use yii\helpers\StringHelper;

/**
 * Class Module
 * @package wdigital\cms\dynamicContentModel
 */
class Module extends BaseModule
{
    /**
     * @var array|string[] class names to be override with custom class and extends original one
     * e.g., multi app support, same models, but with additional property
     */
    public array $modelMap = [
        'Setting' => Setting::class,
        'Content' => Content::class,
    ];

    /**
     * @inheritdoc
     */
    public function init(): void
    {
        parent::init();
        $this->overrideModels();
    }

    /**
     * @return void
     */
    private function overrideModels(): void
    {
        foreach ($this->modelMap as $name => $definition) {
            $modelName = is_array($definition)
                ? $definition['class']
                : $definition;
            if (is_int($name)) {
                $name = StringHelper::basename($modelName);
            }
            Yii::$container->set('wdigital\\cms\\dynamicContentModel\\models\\' . $name, $definition);
            $this->modelMap[$name] = $modelName;
        }
    }
}
