# White Digital CMS Dynamic Content Model Module

Module used for single or multiple element storing in database Content or Setting table with i18n support, e.g., 
footer or hero form setting form. All model attributes stored as Json.

Basic model definition example

```php
<?php

use wdigital\cms\dynamicContentModel\models\AbstractSettingModel;

class HeroForm extends AbstractSettingModel
{
    public string|null $title = null;
    public string|null $description = null;

    /**
     * @inheritDoc
     */
    public function rules(): array
    {
        return [
            [[
                'title',
                'description',
            ], 'string'],
        ];
    }

    /**
     * @inheritDoc
     */
    public function attributeLabels(): array
    {
        return [
            'title' => 'Virsraksts',
            'description' => 'Apraksts',
        ];
    }
}
```

To load model data use:

```php
$values = HeroForm::instantiate();
```

## Module configuration

To override main models (Setting and Content) add to config/main.php file in modules this code:

```php
'content-model' => [
    'class' => wdigital\cms\dynamicContentModel\Module::class,
    'modelMap' => [
        'Setting' => common\models\Setting::class,
        'Content' => common\models\Content::class,
    ],
],
```
