<?php

namespace wdigital\cms\dynamicContentModel\models;

use wdigital\cms\dynamicContentModel\components\HasImageTrait;
use Throwable;
use yii\base\Exception;
use yii\base\Model;
use yii\db\ActiveQuery;
use yii\db\StaleObjectException;
use yii\web\NotFoundHttpException;

abstract class AbstractContentModel extends Model
{
    use HasImageTrait;

    public function imageAttributes(): array
    {
        return [];
    }

    /**
     * @param int|null $id
     * @return static
     */
    public static function instantiate(int $id = null): static
    {
        $classKey = static::class;
        $where = [
            'key' => $classKey,
            'content.id' => $id,
        ];
        $content = Content::find()
            ->innerJoinWith('defaultTranslation')
            ->where($where)
            ->limit(1)
            ->one();
        if (!$content) {
            $content = new Content(['key' => $classKey]);
        }
        $model = (new static());
        $model->setAttributes($content->value);
        return $model;
    }

    /**
     * @throws Exception
     */
    public function insertOrUpdate(int $id = null): bool
    {
        $classKey = static::class;
        $where = [
            'key' => $classKey,
            'content.id' => $id,
        ];
        $content = Content::find()
            ->innerJoinWith('defaultTranslation')
            ->where($where)
            ->limit(1)
            ->one();
        if (!$content) {
            $content = new Content(['key' => $classKey]);
        }
        $this->processImages();
        $content->value = $this->getAttributes();
        return $content->save();
    }

    /**
     * @throws Exception
     */
    public function processImages(): void
    {
        $attributes = $this->imageAttributes();
        foreach ($attributes as $attribute) {
            $this->processImage($attribute);
        }
    }

    public static function findAll(): ActiveQuery
    {
        $classKey = static::class;
        return Content::find()
            ->innerJoinWith('defaultTranslation')
            ->where(['key' => $classKey]);
    }

    public static function all(): array
    {
        $classKey = static::class;
        $contents = Content::find()
            ->innerJoinWith('defaultTranslation')
            ->where(['key' => $classKey])
            ->orderBy('position')
            ->all();
        $models = [];
        foreach ($contents as $content) {
            $model = (new static($content->value));
            $models[] = $model;
        }
        return $models;
    }

    /**
     * @throws Throwable
     * @throws StaleObjectException
     * @throws NotFoundHttpException
     */
    public static function delete(int $id): void
    {
        $content = Content::findOne($id);
        if ($content === null) {
            throw new NotFoundHttpException();
        }
        $imageAttributes = (new static)->imageAttributes();
        $model = (new static($content->value));
        foreach ($imageAttributes as $imageAttribute) {
            $model->deleteImage($imageAttribute);
        }
        $content->delete();
    }
}
