<?php

namespace wdigital\cms\dynamicContentModel\models;

use wdigital\cms\i18new\models\Language;
use yii\db\ActiveQuery;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "content_translation".
 *
 * @property int $content_id
 * @property int $language_id
 * @property string|null $value
 *
 * @property Language $language
 * @property Content $content
 */
class ContentTranslation extends ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName(): string
    {
        return 'content_translation';
    }

    public static function fillable(): array
    {
        return [
            'value',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules(): array
    {
        return [
            [['language_id'], 'required'],
            [['content_id', 'language_id'], 'integer'],
            [['content_id', 'language_id'], 'unique', 'targetAttribute' => ['content_id', 'language_id']],
            [['language_id'], 'exist', 'skipOnError' => true, 'targetClass' => Language::class, 'targetAttribute' => ['language_id' => 'id']],
            [['content_id'], 'exist', 'skipOnError' => true, 'targetClass' => Content::class, 'targetAttribute' => ['content_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels(): array
    {
        return [
            'content_id' => 'Content ID',
            'language_id' => 'Language ID',
            'value' => 'Value',
        ];
    }

    public function getLanguage(): ActiveQuery
    {
        return $this->hasOne(Language::class, ['id' => 'language_id']);
    }

    public function getContent(): ActiveQuery
    {
        return $this->hasOne(Content::class, ['id' => 'content_id']);
    }
}
