<?php

namespace wdigital\cms\dynamicContentModel\models;

use DateTime;
use wdigital\cms\i18new\components\ActiveRecordHelper;
use wdigital\cms\i18new\components\TranslationHelper;
use wdigital\cms\i18new\models\Language;
use yii\base\InvalidConfigException;
use yii\base\Model;
use yii\behaviors\TimestampBehavior;
use yii\db\ActiveQuery;
use yii\db\ActiveRecord;
use yii\helpers\ArrayHelper;
use yii2tech\ar\variation\VariationBehavior;

/**
 * This is the model class for table "content".
 *
 * @property int $id
 * @property string $key
 *
 * @property ContentTranslation[] $contentTranslations
 * @property Language[] $languages
 *
 * @method getVariationModels()
 * @method setVariationModels(array $translationModels)
 * @method hasDefaultVariationRelation()
 * @method static find()
 */
class Content extends ActiveRecord
{
    public static function primaryField(): string
    {
        return 'key';
    }

    public function behaviors(): array
    {
        return [
            'translations' => [
                'class' => VariationBehavior::class,
                'variationsRelation' => 'contentTranslation',
                'defaultVariationRelation' => 'defaultTranslation',
                'variationOptionReferenceAttribute' => 'language_id',
                'variationAttributeDefaultValueMap' => [
                    'value' => null,
                ],
                'optionModelClass' => Language::class,
                'defaultVariationOptionReference' => [TranslationHelper::class, 'getCurrentLanguage'],
                'variationSaveFilter' => [ActiveRecordHelper::class, 'filterVariationSave'],
            ],
            [
                'class' => TimestampBehavior::class,
                'value' => (new DateTime())->format('Y-m-d H:i:s'),
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public static function tableName(): string
    {
        return 'content';
    }

    /**
     * {@inheritdoc}
     */
    public function rules(): array
    {
        return [
            [['key'], 'required'],
            [['key'], 'string', 'max' => 255],
            [['active'], 'boolean'],
        ];
    }

    public function attributeLabels(): array
    {
        return [
            'id' => 'ID',
            'key' => 'Key',
            'created_at' => 'Ieraksts izveidots',
            'updated_at' => 'Ieraksts atjaunots',
        ];
    }

    public function getContentTranslation(): ActiveQuery
    {
        return $this->hasMany(ContentTranslation::class, ['content_id' => 'id']);
    }

    public function getDefaultTranslation(): ActiveQuery
    {
        return $this->hasDefaultVariationRelation();
    }

    /**
     * @param array $data
     * @param null $formName
     * @return bool
     */
    public function load($data, $formName = null): bool
    {
        $translationModels = ArrayHelper::map(
            $this->getVariationModels(),
            'language_id',
            static function ($translatedModel) {
                return $translatedModel;
            }
        );
        return Model::loadMultiple($translationModels, $data) && (bool)$this->setVariationModels($translationModels);
    }

    /**
     * @throws InvalidConfigException
     */
    public function getLanguages(): ActiveQuery
    {
        return $this->hasMany(Language::class, ['id' => 'language_id'])->viaTable('content_translation', ['content_id' => 'id']);
    }

    public function getValues(): array
    {
        return $this->value;
    }
}
