<?php

namespace wdigital\cms\dynamicContentModel\models;

use wdigital\cms\i18new\models\Language;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "setting_translation".
 *
 * @property int $setting_id [int(11) unsigned]
 * @property int $language_id [int(11) unsigned]
 * @property string $value
 */
class SettingTranslation extends ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName(): string
    {
        return 'setting_translation';
    }

    /**
     * @return array
     */
    public static function fillable(): array
    {
        return [
            'value',
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules(): array
    {
        return [
            [['language_id'], 'required'],
            [['setting_id', 'language_id'], 'integer'],
            [['value'], 'string'],
            [['setting_id', 'language_id'], 'unique', 'targetAttribute' => ['setting_id', 'language_id']],
            [['language_id'], 'exist', 'skipOnError' => true, 'targetClass' => Language::class, 'targetAttribute' => ['language_id' => 'id']],
            [['setting_id'], 'exist', 'skipOnError' => true, 'targetClass' => Setting::class, 'targetAttribute' => ['setting_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels(): array
    {
        return [
            'setting_id' => 'Setting ID',
            'language_id' => 'Language ID',
            'value' => 'Value',
        ];
    }
}
