<?php

namespace wdigital\cms\dynamicContentModel\forms;

use wdigital\cms\dynamicContentModel\models\Setting;
use yii\base\Model;
use yii\helpers\Json;
use yii\helpers\StringHelper;

abstract class AbstractSettingModel extends Model
{
    /**
     * @return self
     */
    public static function instantiate(): self
    {
        $classKey = strtolower(StringHelper::basename(static::class));
        $setting = Setting::find()
            ->innerJoinWith('defaultTranslation')
            ->where(['key' => $classKey])
            ->limit(1)
            ->one();
        if (!$setting) {
            $setting = new Setting(['key' => $classKey]);
        }
        return new static(Json::decode($setting->value, true));
    }

    public function insertOrUpdate(): bool
    {
        $classKey = strtolower(StringHelper::basename(static::class));
        $setting = Setting::find()
            ->where(['key' => $classKey])
            ->limit(1)
            ->one();
        if (!$setting) {
            $setting = new Setting(['key' => $classKey]);
        }
        $setting->value = Json::encode($this->getAttributes());
        return $setting->save();
    }
}
