<?php

namespace wdigital\cms\dynamicContentModel\components;

use RuntimeException;
use Yii;
use yii\base\Exception;
use yii\helpers\FileHelper;
use yii\helpers\Inflector;
use yii\helpers\StringHelper;

trait HasImageTrait
{
    /**
     * @param string $attribute
     * @param array $glideOptions
     * @return string
     */
    public function getImageUrl(string $attribute, array $glideOptions = []): string
    {
        $path = strtolower(Inflector::pluralize(StringHelper::basename(static::class)));
        array_unshift($glideOptions, "/getimage/{$path}/{$this->{$attribute}}");
        return Yii::$app->urlManager->createUrl($glideOptions);
    }

    /**
     * @param string $attribute
     * @param array|null $oldAttributes
     * @throws Exception
     */
    public function processImage(string $attribute, array $oldAttributes = null): void
    {
        if (is_string($this->{$attribute}) && false !== strpos($this->{$attribute}, 'data:image')) {
            $data = $this->{$attribute};
            $extension = explode('/', mime_content_type($data))[1];
            if ($extension === 'jpeg' || $extension === 'jpg') {
                $extension = 'jpg';
            } else {
                $extension = 'png';
            }
            $data = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $data));
            $fileName = Yii::$app->security->generateRandomString() . '.'.$extension;
            $folderName = strtolower(Inflector::pluralize(StringHelper::basename(static::class)));
            FileHelper::createDirectory(Yii::getAlias('@storage/' . $folderName));
            file_put_contents(Yii::getAlias('@storage/' . $folderName) . '/' . $fileName, $data);
            if (isset($oldAttributes[$attribute]) && $oldAttributes[$attribute] && file_exists(Yii::getAlias('@storage/' . $folderName) . '/' . $oldAttributes[$attribute])) {
                unlink(Yii::getAlias('@storage/' . $folderName) . '/' . $oldAttributes[$attribute]);
            }
            $this->{$attribute} = $fileName;
        }
    }

    /**
     * @param string $attribute
     */
    public function deleteImage(string $attribute): void
    {
        if ($this->{$attribute} && is_string($this->{$attribute})) {
            $folderName = strtolower(Inflector::pluralize(StringHelper::basename(static::class)));
            $fullPathToFile = Yii::getAlias('@storage/' . $folderName) . DIRECTORY_SEPARATOR . $this->{$attribute};
            if (file_exists($fullPathToFile) && !FileHelper::unlink($fullPathToFile)) {
                throw new RuntimeException("Could not delete file: {$attribute} from: {$fullPathToFile}");
            }
        }
    }
}
