White Digital CMS Audit Module
==============================

The CMS audit module.

Installation
------------

### 1. Download

The preferred way to install this module is via [composer].

First, add the White Digital Composer repository to your `composer.json`:

    "repositories": [{
        "type": "composer",
        "url": "https://composer.wdigital.lv"
    }]

After that, either run

    $ composer require wdigital/cms-audit:^2.0.0

or add

    "wdigital/cms-audit": "^2.0.0"

to the `require` section of your `composer.json` file.


### 2. Configure

Add the module to both web and console applications:

    'modules' => [
        // ...
        'audit' => wdigital\cms\audit\Module::class,
    ],

Bootstrap in the console application to inject URL rules in the web application (recommended, not required):

    'bootstrap' => [
        // ...
        'audit',
    ],


### 3. Migrate

Add new migration namespace to controllerMap config to support migrations for proper audit package functionality:

    'controllerMap' => [
        'migrate' => [
            'class' => yii\console\controllers\MigrateController::class,
                'migrationNamespaces' => [
                    'wdigital\\cms\\audit\\migrations',
            ],
        ],
    ],

And run migrations

    $ php yii migrate

Basic Usage
-----------

    \Yii::$app->getModule('audit')->log('your.category', 'Your message'); // See module phpDoc for parameter details.
    \Yii::$app->getModule('audit')->logPost('other', 'Something posted'); // Call to include post data automatically.

[composer]: http://getcomposer.org/download/
