<?php

use wdigital\cms\audit\models\AuditSearch;
use yii\data\ActiveDataProvider;
use yii\grid\GridView;
use yii\web\View;
use yii\widgets\Pjax;

/**
 * @var View $this
 * @var ActiveDataProvider $dataProvider
 * @var AuditSearch $searchModel
 */

$this->title = Yii::t('audit', 'Audit Logs');
$this->params['breadcrumbs'][] = $this->title;
?>

<?php Pjax::begin() ?>

<?= GridView::widget([
    'dataProvider' => $dataProvider,
    'filterModel' => $searchModel,
    'columns' => [
        'created_at',
        [
            'attribute' => 'user',
            'value' => 'user.email',
        ],
        'ip',
        'category',
        [
            'attribute' => 'message',
            'contentOptions' => ['style' => 'white-space: normal;'],
        ],
        [
          'attribute' => 'data',
          'contentOptions' => ['style' => 'white-space: normal;'],
        ],
    ],
]); ?>

<?php Pjax::end() ?>
