<?php

namespace wdigital\cms\audit\migrations;

use yii\db\Migration;

/**
 * Handles the creation of table `audit`.
 * Has foreign keys to the tables:
 *
 * - `user`
 */
class m171116_081114_create_audit_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $this->createTable('audit', [
            'id' => $this->primaryKey()->unsigned(),
            'user_id' => $this->integer(),
            'ip' => $this->string()->notNull(),
            'category' => $this->string()->notNull(),
            'message' => $this->string(),
            'created_at' => $this->dateTime()->notNull(),
            'data' => $this->text(),
        ]);

        // creates index for column `user_id`
        $this->createIndex(
            'idx-audit-user_id', 'audit', 'user_id'
        );

        // add foreign key for table `user`
        $this->addForeignKey(
            'fk-audit-user_id', 'audit', 'user_id', 'user', 'id', 'CASCADE'
        );
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        // drops foreign key for table `user`
        $this->dropForeignKey(
            'fk-audit-user_id', 'audit'
        );

        // drops index for column `user_id`
        $this->dropIndex(
            'idx-audit-user_id', 'audit'
        );

        $this->dropTable('audit');
    }
}
