<?php

/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace wdigital\cms\audit\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;

/**
 * AuditSearch represents the model behind the search form for Audit.
 */
class AuditSearch extends Model
{
    const FORMAT_DATE_MYSQL = 'Y-m-d H:i:s';

    /**
     * @var mixed
     */
    public $user;

    /**
     * @var string
     */
    public $ip;

    /**
     * @var string
     */
    public $category;

    /**
     * @var string
     */
    public $message;

    /**
     * @var string
     */
    public $created_at;

    /**
     * @var string
     */
    public $data;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            'fieldsSafe' => [['user', 'ip', 'category', 'message', 'data'], 'string'],
            'createdDefault' => ['created_at', 'default', 'value' => null],
        ];
    }

    /**
     * @param $params
     *
     * @return ActiveDataProvider
     */
    public function getDataProvider($params)
    {
        $query = Audit::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        if (!($this->load($params) && $this->validate())) {
            return $dataProvider;
        }

        $query->alias('audit');

        if ($this->created_at !== null) {
            $createdAt = strtotime($this->created_at);
            $query->andFilterWhere([
                'between',
                'audit.created_at',
                date(static::FORMAT_DATE_MYSQL, $createdAt),
                date(static::FORMAT_DATE_MYSQL, strtotime('+1 day', $createdAt)),
            ]);
        }

        $query->joinWith('user');

        $query
            ->andFilterWhere(['like', 'user.email', $this->user])
            ->andFilterWhere(['like', 'ip', $this->ip])
            ->andFilterWhere(['like', 'category', $this->category])
            ->andFilterWhere(['like', 'message', $this->message])
            ->andFilterWhere(['like', 'data', $this->data]);

        return $dataProvider;
    }
}
