<?php

namespace wdigital\cms\audit\controllers;

use wdigital\cms\audit\models\AuditSearch;
use Yii;
use yii\web\Controller;

class DefaultController extends Controller
{
    public function afterAction($action, $result)
    {
        if (is_array($result)) {
            $result = Yii::$app->request->isAjax
                ? $this->renderAjax($this->action->id, $result)
                : $this->render($this->action->id, $result);
        }

        return parent::afterAction($action, $result);
    }

    public function actionIndex()
    {
        $searchModel  = Yii::createObject(AuditSearch::class);
        $dataProvider = $searchModel->getDataProvider(Yii::$app->request->get());

        return [
            'dataProvider' => $dataProvider,
            'searchModel'  => $searchModel,
        ];
    }
}
