<?php

namespace wdigital\cms\audit\models;

use DateTime;
use Yii;
use yii\behaviors\TimestampBehavior;
use yii\db\ActiveQuery;
use yii\db\ActiveRecord;
use yii\db\Expression;

/**
 * This is the model class for table "{{%audit}}".
 *
 * @property integer $id
 * @property integer $user_id
 * @property string $ip
 * @property string $category
 * @property string $message
 * @property string $created_at
 * @property string $data
 * @property-read DateTime $createdAt
 * @property array $dataUnencoded
 * @property-read mixed $user Yii::$app->user->identityClass
 */
class Audit extends ActiveRecord
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::class,
                'attributes' => [ActiveRecord::EVENT_BEFORE_INSERT => 'created_at'],
                'value' => new Expression('NOW()'),
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['ip', 'category'], 'required'],
            [['ip'], 'ip'],
            [['category', 'message'], 'string', 'max' => 255],
            [['data'], 'string'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('audit', 'ID'),
            'user_id' => Yii::t('audit', 'User ID'),
            'ip' => Yii::t('audit', 'IP Address'),
            'category' => Yii::t('audit', 'Category'),
            'message' => Yii::t('audit', 'Message'),
            'created_at' => Yii::t('audit', 'Created At'),
            'data' => Yii::t('audit', 'Data'),
            'user' => \Yii::t('audit','User'),
        ];
    }

    /**
     * @return DateTime
     */
    public function getCreatedAt()
    {
        return new DateTime($this->created_at);
    }

    /**
     * @return array
     */
    public function getDataUnencoded()
    {
        return json_decode($this->data, true);
    }

    /**
     * @param array $data
     * @return $this
     */
    public function setDataUnencoded($data)
    {
        $this->data = json_encode($data);
        return $this;
    }

    /**
     * @return ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Yii::$app->user->identityClass, ['id' => 'user_id']);
    }

}
